# RTC6 Software - Changelog

For versions of release components look at `versions.md`.

Release notes: (B = bugfix, C = change, N = new feature)
A number behind B indicates the version after which the bug
existed.


# `1.22.1`

* RTC6DLL.dll 652,:
    * B: `eth_full_reset`: Fix command always returning an error

* RTC6OUT.out 656, RTC6BIOSETH.out 48:
    * B: `upgrade_bios`: Fix sporadically failing BIOS upgrade

* RTC6RBF.rbf 648:
    * B: `set_laser_power`: Fix LaserON in special timing situations


# `1.22.0`

* RTC6DLL.dll 651, RTC6OUT.out 655, RTC6BIOSETH.out 47:
    * N: `write_io_port_mask_ex_list`: New command with configurable delay
    * C: `set_multi_mcbsp_in`, `set_multi_mcbsp_in_list`: Add new modes for
         defocus variation and online positioning

* RTC6OUT.out 655:
    * B: `set_short_cmd_mode_ctrl`, `set_short_cmd_mode_list`: Fix
         list_continue in unlimited short cmd mode
    * C: `apply_mcbsp`, `apply_mcbsp_list`: Allow to be used with global
         online positioning

* RTC6RBF.rbf 647, RTC6BIOSOUT.out 26:
    * C: Internal changes


# `1.21.0`

* RTC6OUT.out 654, RTC6RBF.rbf 646:
    * C: Internal changes


# `1.20.0`

* RTC6DLL.dll 650:
    * B: Fix undefined behaviour in `load_fly_2d_table`
    * N: Implement `set_verify` for ethernet cards
    * B: Add missing include of stdbool.h in C header
    * B: Add missing declaration of PDouble in Pascal

* RTC6OUT.out 653:
    * B: Fix incorrect start position after external stop in subroutines
    * C: External starts are no longer executed if an external stop is present
         in the same cycle

* RTC6RBF.rbf 645:
    * B: Fix pixelline synchronization with cycle synchronization
    * N: Synchronize Laser1 signal and external clock signal when using cycle
         synchronization with new `set_laser_control` bit 8

* RTC6DLL.dll 650, RTC6OUT.out 653, RTC6RBF.rbf 645, RTC6BIOSETH.out 46:
    * N: New commands `set_explicit_ack_mode_ctrl`, `marking_info_ack_ctrl`,
         `startstop_info_ack_ctrl` for explicit acknowledge/reset of error bits
         in `get_marking_info` and `get_startstop_info`
    * N: `get_startstop_info` bit 6 indicates that previous external stop has
         been caused by automatic laser suppression
    * N: New commands to allow a single SL2-100 error in a specified
         tolerance interval (`set_sl2_100_error_tolerance_ctrl`,
                             `get_sl2_100_error_tolerance_ctrl`,
                             `set_sl2_100_error_tolerance_enable_ctrl`,
                             `get_sl2_100_error_tolerance_enable_ctrl`)

* RTC6conf 1.5.2.0:
    * B: Fix program freeze in RIF mode


# `1.19.4`

* RTC6DLL.dll 649:
    * C: Internal changes

* RTC6OUT.out 652:
    * B: Fix `auto_cal`
    * B: Fix `jump_abs_drill_3`, `jump_rel_drill_3` delays

* RTC6RBF.rbf 644:
    * C: Internal changes

* RTC6BIOSETH.out 45:
    * B: Fix remote interface `load_correction_file` return value

* RTC6BIOSOUT.out 25:
    * C: Internal changes

* RTC6conf 1.5.1.0:
    * C: Reduce CPU usage


# `1.19.1`

* RTC6DLL.dll 648:
    * B: Fix `get_scanahead_params` for PCIe cards

* RTC6OUT.out 651:
    * C: Internal changes

* RTC6RBF.rbf 643:
    * B: Fix 16-bit digital input at `EXTENSION 1`
    * B: Fix nonlinearity for `ANALOG OUT1` and `ANALOG OUT2`
    * B: Fix missing SL2-100 errors in `get_startstop_info`

* RTC6BIOSETH.out 44:
    * C: Internal changes


# `1.19.0`

* RTC6conf 1.5.0.0:
    * N: Show additional Remote Interface status

* RTC6BIOSETH.out 43, RTC6DLL.dll 650:
    * N: Include Remote Interface status in `eth_get_card_info_search`

* RTC6BIOSETH.out 43, RTC6OUT.out 650, RTC6DLL.dll 647:
    * N: `set_laser_delays_ctrl`: Control command of `set_laser_delays`
    * N: `set_scanner_delays_ctrl`: Control command of `set_scanner_delays`
    * N: `get_rcm_value_ctrl`, `demux_rcm_ctrl`: Return channel multiplexing
         for supported scanheads
    * N: `get_extended_head_status_value_ctrl`,
         `get_extended_head_status_block_ctrl`: Extended head status for
         supported scanheads
    * N: `set_sky_writing_min_speed_list`: List command of
         `set_sky_writing_min_speed_ctrl`
    * N: `set_sky_writing_scale_ctrl`, `set_sky_writing_scale_list`:
         Sky writing with prolonged prerun/postrun
    * N: `master_slave_set_offset_ctrl`: Offset compensation for more strict
         synchronization requirements

* RTC6OUT.out 650, RTC6DLL.dll 647:
    * N: `eth_full_reset`: Perform hardware reset
    * N: `upgrade_bios`: Flash BIOS firmware version

* RTC6BIOSETH.out 43, RTC6DLL.dll 647:
    * C: `control_command`: Create REJECTED error if blocked by auto laser ctrl
    * C: `set_auto_laser_control`: Allow reconfiguration without having to
         disable auto laser ctrl
    * B: `set_scanahead_params`, `get_scanahead_params`: Fix invalid return
         values

* RTC6DLL.dll 647:
    * B: `acquire_rtc`: Fix invalid serial number after acquire
    * B: `load_correction_file`: Fix corrupted correction file header

* RTC6OUT.out 650:
    * B: `stop_execution`: Fix short list command execution after stop
    * B: `park_return_2_axes`: Fix ignored parameter `Mode`
    * B: `set_rot_center_list`: Fix incorrect rot center position
    * B: `rs232_read_data`: Fix broken read after `2^32` transfers
    * B: SCANahead: Fix vectors exceeding Vmax due to 10us rounding

* RTC6RBF.rbf 642:
    * C: Fix master/slave synchronization for more than 3 cards

* RTC6BIOSOUT.out 24:
    * C: Internal changes


# `1.18.0`

* RTC6conf 1.4.0.0:
    * N: Remote Interface can be enabled

* RTC6BIOSETH.out 42:
    * N: Remote Interface implement unavailable commands (see `telegrams.h`)
    * N: `load_correction_file` verifies checksum independently of `set_verify`
         setting
    * N: Remote Interface can be temporarily enabled till next power cycle
         (without Standalone mode)
    * B: Fix `set_sky_writing_para_list`

* RTC6OUT.out 649, RTC6DLL.dll 646:
    * N: `set_auto_laser_control`: new mode 2 extension +128 to combine
         spot distance control with sky writing
    * N: `set_encoder_filter_ctrl`: new mode 1 to disable/enable of
         encoder signal input filter
    * N: `set_sky_writing_min_speed_ctrl`: Use sky writing with minimum
         mark velocity < 100%
    * N: `set_defocus_2_list`: variation of defocus with hard jump
    * N: `set_sky_writing_mode`, `set_sky_writing_mode_list`: New mode 4
         to allow short list commands between sky writing vectors
    * N: `set_fly_tracking_error`: Implementation done: configure tracking
         error for encoder values
    * N: `set_short_cmd_mode_ctrl`, `set_short_cmd_mode_list`: configure
         behavior of short list commands
    * B: `read_io_port_buffer`: Fix unwanted limitation to first 256 buffer
                                values
    * B: Sky Writing: Fix Z movement in Sky Writig modes 2 and 3

* RTC6OUT.out 649:
    * B: `set_sky_writing_mode`, `set_sky_writing_mode_list`: disable for
         `Mode > 0` if enabled with `1/8 < Timelag < 1/4`

* RTC6RBF.rbf 641:
    * B: `wait_for_encoder_mode`: fix infinite waiting on certain settings
         of Mode and Fly Scale
    * N: `set_auto_laser_control`: New mode extension +128 to combine Spot
         Distance Control with Sky Writing
    * N: `set_encoder_filter_ctrl`: New mode 1 to config encoder input signal
         filter


# `1.17.0`

* RTC6DLL.dll 644, RTC6OUT.out 647:
    * N: `fly_disable_list`: Disables only fly in auto laser control
         mode +4 but leaves encoder correction turned on

* RTC6RBF.rbf 640:
    * C: internal changes

# `1.16.3`

* RTC6BIOSETH.out 40:
    * C: Data-Streaming: Add BIOS version to streaming meta data

# `1.16.2`

* RTC6OUT.out 646:
    * B: `SCANahead`: fix too short SCANahead auto jump delays
         caused by coordinate transformations

# `1.16.1`

* RTC6conf 1.3.1.0:
    * B: Remote Interface: Fix card detection on multiple restarts
    * B: Remote Interface: Can be detected and disabled

* RTC6BIOSETH.out 39:
    * B: Remote Interface: Fix wrong initialization of `seqnum` variable
    * B: Data-Streaming: Fix card crash with BIOS 38
    * B: Ethernet Phy: Fix wrongly lit LED without assigned IP address
    * N: Remote Interface: Control without RTC6DLL
    * B: Ethernet Phy: Fix wrongly dimming LED without Standalone Boot

* RTC6DLL.dll 643, RTC6OUT.out 645:
    * N: `init_fly_2d_list`: list command version of `init_fly_2d`
    * N: `set_auto_laser_control`: new mode +64 for back transformations
         of coordinates
    * N: `set_encoder_filter_ctrl`: configure a filter for encoder signals
    * N: `eth_set_remote_tgm_format`: boot command to enable the
         remote interface mode

* RTC6OUT.out 645:
    * B: `mcbsp_init`: fix random frequency if called without preceding
         `set_mcbsp_freq`
    * B: `list_jump_rel[_cond]`: fix relative list jumps in nested sub
         programs
    * B: `set_auto_laser_control`: fix correction for Mode 4 with
         `set_fly_x` and `set_fly_y`
    * B: `Sky-Writing`: fix missing LaserON in special timing situations

* RTC6RBF.rbf 639:
    * B: `EXTENSION 1`, `EXTENSION 2`: fix two `LATCH OUT` pulses per
         write
    * N: `set_encoder_filter_ctrl`: configure filter for encoder signals
    * B: laser control: apply changes of PulseLength and HalfPeriod within
         a polyline at the correct time

# `1.15.5`

* RTC6BIOSETH.out 37:
    * B: Data-Streaming: Fix incomplete data transmission

* RTC6DLL.dll 639:
    * B: `set_ellipse`: Fix endless loop for `| phi | >= 2880.0`
    * C: `set_ellipse`: Valid range for `phi` reduced to `-2880 <= phi <= 2880`

* RTC6OUT.out 640:
    * B: `set_ellipse`: Fix endless loop for `| phi | >= 2880.0`
    * B: `wait_for_encoder[_mode]`: fix position in combination with
         `set_fly_rot` to avoid hard jumps
    * B: `activate_fly_2d[_encoder], activate_fly_xy[_encoder]`: fix scaling

# `1.15.4`

* RTC6DLL.dll 638:
    * B635: `get_transform`: fix back transformation

* RTC6OUT.out 639:
    * B: `set_trigger8`: fix erroneous data during stop of data streaming

* RTC6RBF.rbf 637:
    * B: laser control: fix LaserON not turned off during jump in special
         timing situations

# `1.15.3`

* RTC6OUT.out 638:
    * B: `set_trigger[4,8]`: fix erroneous data for scan head status signals
         if used outside of list (Bit 30 = 1)
    * B: `set_auto_laser_control`: fix automatic laser control stopped to soon
         in PAUSED status for Mode = 50


# `1.15.2`

* RTC6DLL.dll 637:
    * B: `eth_set_com_timeouts_auto`: Fix `udp_recv_timeout` errors happening
         before `MaxTimeout` elapses

* RTC6OUT.out 637:
    * B: `set_multi_mcbsp_in[_list]`: fix initialization of analog outputs
    * B: `set_mcbsp_in_list`: prevent hard jump on multiple calls

* RTC6RBF.rbf 636:
    * B: laser control: fix displacement of LaserOn signals in case of
         LaserOn delays larger than 2.55 ms and parallelly continuously
         outputting data to a port (AnalogOut1, AnalogOut2, DigitalOut0,
         DigitalOut1)

# `1.15.0`

* RTC6conf 1.2.2.1:
    * C: New message after BIOS-/Options upgrade

* RTC6BIOSETH.out 36:
    * N: Data-Streaming: Transmit data independently of the user program,
                         see manual

* RTC6OUT.out 636:
    * B: vector commands: fix execution time calculation for all vector
         commands with length larger than `2^25` (virtual image field)

* RTC6DLL.dll 635, RTC6OUT.out 636:
    * N: `eth_config_waveform_streaming_ctrl`: Configure data streaming
    * N: `set_trigger8`: Record up to 8 channels

* RTC6DLL.dll 635:
    * N: `get_transform_offset`: back transformation of data from position
                                 `offset`
    * C: `get_transform`: Increase maximum number of elements from 2^23
                          to 2^24

* RTC6RBF.rbf 635:
    * N: `get_rcm_low_bw_value_ctrl`, `get_rcm_low_bw_block_ctrl`,
         `get_rcm_high_bw_value_ctrl`, `demux_rcm_high_bw_ctrl`:
         return channel multiplexing

# `1.14.1`

* RTC6BIOSETH.out 35:
    * B: `eth_set_high_performance_mode`: Fix UDP timeout with control commands

* RTC6DLL.dll 634, RTC6OUT.out 635, RTC6RBF.rbf 634:
    * N: `write_port_list`: output analog/digital values - with parameter
         `NoDelay` output happens before `PreviewTime` ellapses

# `1.14.0`

* RTC6conf 1.2.2.0:
    * B: Fix succeeded options upgrade message on failure

* RTC6BIOSETH.out 34:
    * N: `eth_set_high_performance_mode`: increase list download performance


* RTC6OUT.out 634:
    * C: runtime optimization
    * B: `laser_on_list`: fix wrong `LaserON` signal with `SCANahead`
         auto delays
    * B: `coordinate transformations`: fix Z output for `at_once = 2`
    * B: `set_multi_mcbsp_in_list`: fix hard jumps on multiple calls

* RTC6DLL.dll 633, RTC6OUT.out 634:
    * N: `set_mcbsp_out_oie_ctrl`, `set_mcbsp_out_oie_list`:
         new output mode for McBSP for OIE application
    * N: `set_controlpreview_compensation_ctrl`: compensate ControlPreview time
         of a scan head

* RTC6DLL.dll 633:
    * N: `eth_set_high_performance_mode`: increase list download performance

# `1.13.0`

* RTC6DLL.dll 632:
    * B: `set_mcbsp_out_ptr`: fix null pointer exception
    * C: `set_mcbsp_out_ptr`: output LaserOn status on bit 31 of McBSP value
    * N: `set_mcbsp_out_ptr_list`: list command to `set_mcbsp_out_ptr`
    * B: `load_z_table_20b`, `load_z_table_no_20b`, `write_abc_to_file_20b`,
         `read_abc_from_file_20b`: fix conversion of ABC coefficients

* RTC6OUT.out 633:
    * C: `set_mcbsp_out_ptr`: output LaserOn status on bit 31 of McBSP value
    * N: `set_mcbsp_out_ptr_list`: list command to `set_mcbsp_out_ptr`
    * C: `enduring wobbel`: fix for SCANahead Autodelays
    * B: `load_fly_2d_table`: fix encoder value correction

* RTC6RBF.rbf 633:
    * B: laser control: fix LaserON staying on after mark or a pixel line
         in special timing situations

# `1.12.0`

* RTC6conf 1.2.1.0:
    * C: Increase Ethernet timeouts

* RTCBIOSETH.out 33:
    * B: Ethernet: Fix acquire

* RTC6DAT.dat 604:
    * N: New data table for `set_wobbel_vector_2`

* RTC6DLL.dll 631, RTC6OUT.out 632:
    * B: `load_list`: fix wrong list load for `ListNo = 3`
    * B: `set_auto_laser_control`: fix premature end of Laser1 signal output at
         end of list for `Mode = 50`
    * B: `SCANahead`: fix wrong switching of LaserOn signal for short AutoDelays
    * N: `get_temperature`: read card temperature
    * N: `set_wobbel_vector_2`: support alternating power variation with free
         wobbel figures

* RTC6DLL.dll 631:
    * B: `load_program_file`: fix wrong ethernet error code
    * N: `load_z_table_20b`, `load_z_table_no_20b`, `write_abc_to_file_20b`,
         `read_abc_from_file_20b`: handle ABC coefficients in 3D correction
         tables that were calculated with a 20 bit focus length value

* RTC6RBF.rbf 632:
    * C: internal changes

# `1.11.0`

* RTCBIOSETH.out 32:
    * C: Ethernet: Improve acquire/release

* RTC6OUT.out 631:
    * B: `set_multi_mcbsp_in_list`: fix infinitely repeated command on list
         output

* RTC6DLL.dll 630, RTC6OUT.out 631:
    * N: `set_wobbel_control`: new control parameter `Ctrl = 8` for alternating
         power variation of `ANALOG OUT1` and `ANALOG OUT2`

# `1.10.0`

* RTCBIOSETH.out 31, RTC6DLL.dll 629:
    * C: Ethernet: Improve acquire/release

* RTC6OUT.out 630:
    * B: `laser_on_list`: fix permanent LaserON signal in combination with
         Sky-Writing modes 2 and 3
    * B: `regulation3`: do not ignore Wobbel

* RTC6RBF.rbf 631:
    * B: `set_laser_power`: fix power change between two marks happening too
         early

# `1.9.0`

* RTC6conf 1.2.0.0:
    * N: New button to erase Standalone program/data
    * N: Show laserDESK Standalone option if available

* RTCBIOSETH.out 30:
    * N: `eth_get_standalone_status`: get status during
         Standalone boot

* RTC6OUT.out: 629:
    * B: `wait_for_encoder[_mode,_in_range,_in_range_mode]`, `wait_for_mcbsp`:
         fix execution of following up jump and marks
    * N: `clear_fly_overflow_ctrl`: control command of `clear_fly_overflow`

* RTC6DLL.dll 628:
    * N: `eth_get_standalone_status`: get status during
         Standalone boot
    * N: Linux: new dpkg for Debian 11 (bullseye)
    * N: `clear_fly_overflow_ctrl`: control command for `clear_fly_overflow`
    * B: `n_read_image_eth`, `n_write_image_eth`: use multiboard commands
         instead of single board commands

* RTC6RBF.rbf 630:
    * B: laser control: fix output of wrong pixel lines

# `1.7.12`

* RTCBIOSETH.out 29:
    * B: Ethernet Gateway: Fix `eth_set_static_ip` not applying
         gateway setting

* RTC6OUT.out 628:
    * B: `timed mark/jump`: fix wrong velocity for laser delay calculation
    * B: `set_io_cond_list`, `clear_io_cond_list`: fix port bits overwriting
         by following outputs to the same port
    * B: `regulation3`: fix variation of laser frequency and puls length for
         changes of encoder frequency

* RTC6DLL.dll 627:
    * C: only internal changes

# `1.7.11`

* RTC6DLL.dll 626:
    * C: only internal changes

* RTC6RBF.rbf 629:
    * C: laser control: internal changes

# `1.7.10`

* RTC6OUT.out 626:
    * C: internal changes

# `1.7.9`

* RTC6DLL.dll 625, RTC6OUT.out 625:
    * B: `load_correction_file`: fix permanent `INTERNAL-BUSY` status for
         `No >=3` on loading correction tables

* RTC6DLL.dll 625:
    * B: `eth_set_com_timeouts`: fix ignored timeouts / DLL deadlock on
         connection abort

* RTC6RBF.rbf 628:
    * C: laser control: internal changes

# `1.7.8`

* RTC6DLL.dll 624, RTC6OUT.out 624:
    * N: `get_timestamp_long`: read 64 bit `TimestampCounter`
    * N: `wait_for_timestamp_counter_long`: on list execution, wait for absolute
         value of 64 bit `TimestampCounter`

* RTC6RBF.rbf 627:
    * C: laser control: internal changes

# `1.7.7`

* RTC6DLL.dll 623, RTC6RBF.rbf 626:
    * B: `set_laser_power`: fix sporadically appearing additional latch signal
         appearing after `load_program_file`
    * B: `set_scanahead_params`: fix wrong LaserOn Signal if used without
         connected excelliSCAN

# `1.7.6`

* RTCBIOSETH.out 28:
    * N: `eth_configure_link_loss`: Configure behavior on link loss
    * B: list processing: Fix 10us cycle overflow when executing and
                          writing lists the same time

* RTC6DLL.dll 622:
    * N: `eth_configure_link_loss`: Configure behavior on link loss
    * B: `ethernet`: fix never returning DLL functions for several functions
         which wait for a card response
    * B: `micro_vector_rel_3d`: use relative coordinates instead of absolute

# `1.7.5`

* RTC6OUT.out 621:
    * B: `load_z_table_no`: fix wrong ABC values with assigned 3D correction
         table for `No != 0`.

* RTC6DLL.dll 621:
    * B: `load_z_table_no`: fix wrong ABC values with assigned 3D correction
         table for `No != 0`.
    * B: `simulate_ext_stop`: fix possible too early execution of following
         command

# `1.7.4`

* RTC6OUT.out 620:
    * B: `periodic_toggle`, `periodic_toggle_list`: fix port outputs

* RTC6DLL.dll 620:
    * B: `periodic_toggle`, `periodic_toggle_list`: fix port outputs
    * N: `eth_set_com_timeouts_auto`, `eth_get_com_timeouts_auto`:
         new mechanism to configure UDP timeouts

* RTC6RBF.rbf 625:
    * B: laser control: fix wrong Laser1 pulses after abort of a pixel line
         with active pulse completion

# `1.7.3`

* RTCBIOSETH.out 27:
    * B: Standalone: Fix yellow LED indicating error despite correct Standalone
                     boot.

* RTC6OUT.out 619:
    * B: `set_default_pixel`: fix default pixel output in extended mode
         (Channel = 21)
    * B: `release_wait`: fix list execution after `release_wait`
    * B: `para_mark_[abs, abs_3d, rel, rel_3d]`: fix missing signal parameter
         output on Null vectors, fix wrong parameter output for following para
         commands

* RTC6DLL.dll 619, RTC6OUT.out 619:
    * N: `wait_for_timestamp_counter_mode`: same as without `_mode` with `mode`
         specifying behavior on already expired `Counter`.
    * C: `get_startstop_info`: bit 5 shows if start time for
         `wait_for_timestamp_counter` has already expired

* RTC6DLL.dll 619:
    * B: `load_program_file`: fix possible exception on ethernet cards
    * C: `load_sub`, `load_char`, `load_text_table`: input pointer now
         invalidated and error `RTC6_REJECTED` returned if end of list memory 3
         reached in a sub procedure
    * B: `periodic_toggle`, `periodic_toggle_list`: fix scaling of `ANALOG_OUT1`
         and `ANALOG_OUT2` (was too small by factor 16)
    * C: `eth_get_com_timeouts`: non-acquired cards don't drop an error
         `RTC6_ETH_ERROR` but return 0 for `KeepAlive` and `KeepInterval`
    * C: `eth_set_com_timeouts`: only set values if card is not acquired and
         if `KeepAlive` / `KeepInterval` nonzero

* RTC6RBF.rbf 624:
    * B: laser control: fix elongated mark vectors due to erroneously processed
         laser-off-delays

# `1.7.1`

# `1.7.0`

* RTCBIOSETH.out 26:
    * N: Standalone: Ethernet cards can work standalone

* RTCOUT.out 618:
    * B: `set_ellipse`: fix getting stuck on certain parameters
    * B: `set_angle`: fix missing transformation for head 4

* RTC6DLL.dll 618:
    * N: Standalone: Ethernet cards can work standalone
    * C: `store_program`: new Mode > 1 stores data for full Standalone mode
    * N: `set_eth_boot_control`: Enables or disables automatic boot in
         Standalone mode
    * N: `eth_boot_dcmd`, `set_eth_boot_timeout`: command to configure the
         Standalone boot sequence
    * N: `read_image_eth`, `write_image_eth`: clone boot images
    * B: `store_timestamp_counter`, `store_timestamp_counter_list`,
         `wait_for_timestamp_counter`: execution


# `1.6.1`

* RTC6OUT.out 617:
    * B: `laser control`: fix laser switching for certain combinations of
         mark/jump and micro vector commands
    * B: `automatic laser control`: fix wrong Mode 1 correction
    * B: `set_fly_z`, `set_fly_x`: fix wrong fly correction on call of
         `set_fly_x` after `set_fly_z`
    * B: `set_fly_limits[_z]`, `get_marking_info`: fix user defined fly
         limits from being a factor of 32 to large

* RTC6DLL.dll 617, RTC6OUT.out 617:
    * C: `set_angle`: allow `HeadNo = 4`
    * C: `set_trigger`, `set_trigger4`: signals 59-62
    * C: `get_startstop_info`: Bit 14 indicates laser acquisition status
         (1 = enabled, 0 = disabled)
    * N: `store_timestamp_counter`, `store_timestamp_counter_list`: stores
         current TimestampCounter value on card
    * N: `wait_for_timestamp_counter`: suspend list execution until given
         counter value is reached
    * N: Fly Extension: free assignment of encoder and axes to generically
         control processing on the fly
    * N: Global online positioning: coordinate transformations in virtual
         image field, transmitted by McBSP

* RTC6DLL.dll 617:
    * B: `set_pixel_line`, `set_pixel_line_3d`: fix pixel mode with Channel 21
         (Port 5 + Mode 16): pixel output for PulseLength
    * B: `load_list`: For `ListNo = 3`, unset USED status in correct list always
    * B: `acquire_rtc`, `select_rtc`, `n_load_program_file`: fix exception for
         RTC6eth cards
    * B: `get_waveform_offset`: fix bluescreen on certain combinations of offset
         and length
    * B: `write_abc_to_file`: fix wrong checksum in correction files
    * B: `init_rtc6_dll`: Fix race condition resulting in dead lock if
         several programs make use of DLL simultaneously
    * B: `set_multi_mcbsp_in`: fix wrong outputs

* RTC6RBF.rbf 623:
    * B: `set_control_mode`: fix clear of delay queue with set bit 1
    * B: `set_ext_start_delay`: fix external start with expired track delay

# `1.6.0`

* RTC6DLL.dll 616, RTC6OUT.out 616, RTC6RBF.rbf 622:
    * N: laser control: SybCycleSwitching, only for laserDESK and RTC6AddOnDll

* RTC6DLL.dll 616:
    * B: `load_jump_table_offset`: Fix automatic detection

* RTC6RBF.rbf 622:
    * C: internal changes
    * N: laser control: Correctly update Pulse Picking Number

# `1.5.2`

* RTC6conf 1.1.0.5:
    * B: Fix upgrade of RTC6eth cards if built-in RTC6e cards exist
    * B: Fix BIOS/options upgrade if files are not in current working directory

* RTC6OUT.out 615:
    * `automatic laser control`: fix wrongly calculated power for combined
      Galvo + Encoder velocity

* RTC6DLL.dll 615, RTC6OUT.out 615:
    * C: `range_checking`: Mode 2: forward `simulate_ext_stop` to all slave
         cards

* RTC6DLL.dll 615:
    * C: `eth_set_com_timeouts`, `eth_get_com_timeouts`: make pure DLL settings
         possible without an ethernet card
    * C: `save_disk`, `load_disk`: add version control
    * C: `sync_slaves`: remove functionality (see RBF 619)

* RTC6RBF.rbf 621:
    * C: internal changes

# `1.5.0`

* RTC6conf 1.1.0.4:
    * N: Store network settings in ini-file and reload on program restart
    * B: Fix upgrade file problems with underscore in filename
    * B: Fix flashing of IP network configuration
    * B: fix program hang after card reboot

* RTC6BIOSETH.out 25:
    * B24: `get_waveform`: outdated data packet

* RTC6DAT.dat 603a:
    * B: Fix `load_auto_laser_control`

* RTC6OUT.out 614:
    * C: `set_wobble_mode`: Mode 3: user defined Wobbel figure with changed
         power variation
    * B: time limited circle arcs with Sky-Writing Mode 2: Fix hard jumps due to
         wrongly calculated pre run positions for `excelliSCAN` with
         `activate_scanahead_autodelays(1)`

* RTC6DLL.dll 614, RTC6OUT.out 614:
    * B: `activate_fly_2d_encoder`, `activate_fly_xy_encoder`: fix usage of
         encoder offsets
    * N: `load_fly_2d_table`, `init_fly_2d`: implementation of XY-table encoder
         correction; 2 tables available; change parameters of `Init_fly_2d` to
        `(OffsetX, OffsetY, No)`.
    * C: `Processing-on-the-fly`: complete implementation for excelliSCAN
    * B: `get_table_para`: make it work for tables 5-8
    * C: `global coordinate transformation for virtual image field`:
         available without `Processing-on-the-fly`. Can be disabled explicitly.
    * C: `set_vector_control`: outputs synchronized to laser on ports 1, 2, 3, 6
    * B: `para`-commands: Ctrl = 7: Multiply Defocus by 16 in RTC4/RTC5 Mode
    * B: `set_defocus_offset[_list]`: fix usage of offset values
    * N: `wait_for_encoder_mode`, `wait_for_encoder_in_range_mode`:
         support PreviewTime-corrected or direct encoder values
    * C: `automatic laser control`: fix overflow with factor 4 by clipping
    * C: global coordinate transformations (virtual image): possible for
         `set_fly_x` and `set_fly_y`
    * N: `uart_config`: configure UART-interface (was RS232)
    * N: `load_z_table_no`: loads ABC values into a given table, which can be
         selected with `select_cor_table` as well. `load_z_table_no(A,B,C,0)` is
         same as `load_z_table`
    * N: `time_control_eth`: adjusts offset and frequency of real time clock
    * N: `real time clock`: `time_update` programs real time clock for RTC6eth

* RTC6DLL.dll 614:
    * C: `set_pixel_line`, `set_pixel_line_3d`: sky-writing-mode
    * B: `load_program_file`: return 9 on RTC6ETH.out-Fehler only for
         ethernet cards
    * C: `load_program_file`: New return values 11, 14, 16, 17, 18

* RTC6RBF.rbf 619:
    * C: `master/slave`: Improved functionality, automatic sync - call of
         `sync_slaves` not needed
    * C: `UART`: replace `RS232` (enable higher baud rates)
    * B: `laser control`: fix mutual influence of two LaserOff Delays A and B
         so that after A the laser stayed on until B
    * C: `encoder`: PreviewTime-corrected encoder values for excelliSCAN

# `1.4.4`

* RTC6BIOSETH.out 24:
    * C: Ethernet: Fix connection losses
    * N: `FORCE_DHCP`: Use a link-local-address (169.254.1.0/16), if
         no DHCP lease is granted within 60 seconds after power up.
    * B: `release_rtc`: fix locked-up card on UDP packet loss
    * B: `eth_get_static_ip`: fix readout of static ip of 0 if
                              `FORCE_DHCP` jumper set

* RTC6DAT.dat 603:
    * C: New initialization of `load_position_control` table

* RTC6OUT.out 611:
    * B: Circle arcs with Sky-Writing Mode 2: Fix hard jumps due to
         wrongly calculated pre run positions for `excelliSCAN` with
         `activate_scanahead_autodelays(1)`
    * C: LaserOn delay: `excelliSCAN + activate_scanahead_autodelays(1)`:
         Use Q-Switch-Delay for LASERON-Delay instead of
         FirstPulseKiller Signal
    * B: Sky-Writing Mode: `excelliSCAN`: fix very slow pre run for low
         velocities
    * C: `set_scanahead_speed_control`: fix mismatched laser delays
    * B: `set_laser_pin_out_list`: fix wrong timing
    * B: `set_fly_rot`: fix error immediately after `load_program_file`.
         workaround was: use `set_fly_x(1.0)` before

* RTC6DLL.dll 611, RTC6OUT.out 611:
    * C: `mark_ellipse_abs`, `mark_ellipse_rel`: allow ellipses with
         excelliSCAN in Sky-Writing-Mode
    * B: `get_z_distance`: use current Z psotion instead of paramter Z
    * B: automatic laser control, `load_position_control`:
         Fix scaling error due to rework of position-independent for excelliSCAN
         compatibility. Error happened if no table was loaded with
         `load_position_control` explicitly (See RTC6DAT.dat 603).

* RTC6DLL.dll 611:
    * N: `FORCE_DHCP`: Use a link-local-address (169.254.1.0/16), if
         no DHCP lease is granted within 60 seconds after power up.
    * B: `release_rtc`: fix locked-up card on UDP packet loss
    * B: `eth_get_static_ip`: fix readout of static ip of 0 if
                              `FORCE_DHCP` jumper set
    * B610: `get_scanahead_params`: fix check for excelliSCAN
    * B610: `set_scanahead_params`: fix broken Mode 1 due to above
    * B: `set_scanahead_params`: fix Mode 2 scaled image field velocities
         and accelerations due to wrong correction file evaluation


# `1.4.2`

* RTC6DAT.dat 602:
    * C: initialize with user defined tables

* RTC6OUT.out 610:
    * B609: `list_call`, `list_call_abs`: fix repeated call of `address`
            function
    * B609: `set_wobbel_vector`: fix amplitude factor 32 too large
    * B: pixelmode: fix data loss for pixel line durations > 2.56 ms,
         fix non-working next pixel line after `stop_execution` or
         `/STOP` signal.
    * B: XY-coordinates (sample values): fix coordinates out of range
         for real image field (as well after fly correction)

* RTC6DLL.dll 610, RTC6OUT.out 610:
    * N: `set_pause_list_not_cond`: sets not condition for `EXTENSION 1`,
         16-bit digital input for automatic `pause_list`.
    * N: `set_scanahead_speed_control`: controls Scanner-Delays dependently
         on set and actually reachable velocity
    * N: `activate_fly_xy_encoder`, `activate_fly_2d_encoder`: enable
         `Processing on the Fly` session with encoder offset
    * C: `set_trigger`, `set_trigger4`: period uses 31 bits, bit #31 = 1
         enables endless trigger with ringbuffer

* RTC6DLL.dll 610:
    * N: `get_waveform_offset`: reads data from position offset onwards
    * N: `create_dat_file`: generate DAT file of current version which
         includes user defined tables
    * B: `get_encoder`, `read_encoder`, `wait_for_encoder`: fix wrongly
         scaled values by FlyScale since RBF 614
    * C: `conditional pause_list`: higher priority than `stop_execution`

* RTC6RBF.rbf 615:
    * B: `get_encoder`, `read_encoder`, `wait_for_encoder`: fix wrongly
         scaled values by FlyScale since RBF 614, fix encoder reset for
         encoder Y
    * B: automatic laser control (SpotDistanceControl): fix calculated
         distance for high velocities
    * B: pixel mode: fix loss of pixel data for line duration > 2.56 ms,
         fix resume after `stop_execution` or `/STOP`
    * B: laser control: fix wrong laser signal after `set_timelag_compensation`
    * B: laser control: excelliSCAN: fix laser staying on after lots of
         short marks and jumps

# `1.4.1`

* RTCBIOSETH.out 23:
    * C: Reboot: Automatic load of program files from NAND is temporarily
                 disabled
    * B: `load_program_file`: Files from revision < 1.4.1 could fail with
                              `Board not running`. (Upgrade in field not
                              possible with files from revision < 1.3.2.)
* RTCBIOSOUT.out 23:
    * B: `load_program_file`: Files from revision < 1.4.1 could fail with
                              `Board not running`.

* RTC6OUT.out 609:
    * B: vector controlled laser control: Ctrl = 1 and Ctrl = 2:
         Fix wrong scaling and clipping of AnalogOut
    * C: automatic laser control: better regulation of half period
         (geometric spot distance), only for excelliSCAN
    * B: automatic laser control: excelliSCAN: fix non-delayed changes of
         marking speed, that must be delayed by PreviewTime
    * C: Sky-Writing Mode 3, Polygon-Delay: angle calculation completely in 3D
    * C: micro vector commands: respect PreviewTime delay in laser delays
         automatically
    * B: `set_timelag_compensation`: fix endless waiting for not `HEAD_BUSY`
    * B: `fly_return_z`: fix wrong interpretation as 16 bit value in RTC6 mode

* RTC6DLL.dll 609, RTC6OUT.out 609:
    * N: `set_pause_list_cond`: sets condition for `EXTENSION 1`,
         16-bit digital input for automatic `pause_list`.
    * N: `set_defocus_offset`, `set_defocus_offset_list`: globally applied
         offset for all defocus settings
    * N: `list_call_repeat`, `list_call_abs_repeat`: Like `list_call`
         and `list_call_abs` respectively, but with settable repetition
    * C: `set_trigger`, `set_trigger4`, `get_value`, `get_values`: added signals
         53 (Wobbel-amplitude) and 54 (I2C-AnalogIn) as well as 55, 56, 57
         (Fly-Correction)
    * N: `spot_distance`, `spot_distance_ctrl`: define wanted, constant
         geometrical spot distance to be regulated
    * C: `get_sync_status`: provide error bits in addition to `Master/Slave`-
         sync status
    * N: `set_port_default_list`: list command to `set_port_default`


* RTC6DLL.dll 609:
    * B: `eth_check_connection`: fix wrong values > 0
    * B: `Windows-Service`: fix usage as windows service
    * C: `import declarations`: `RTC6impl.h`, `RTC6expl.h`, `RTC6expl.c`,
         `RTC6impl.hpp` prepared for non-Windows operating systems
    * C: `import declarations`: `set_pixel`, `set_n_pixel`: params `PulseLength`
         and `AnalogOut` renamed to `PortOutValue1` and `PortOutValue2`.
    * C: `correction files`: optional command `number_of_correction_tables`
          limits number of valid correction tables for the user to less than 8
    * N: `master_slave_config`: configure the `Master/Slave`-connection
    * C: `automatic laser control`: `set_auto_laser_control`,
         `set_auto_laser_params[_list]` with Ctrl = 7: geometrically constant
         spot distance, only for systems wiht excelliSCAN
    * B: `set_scanahead_params`: return error 3 (no active excelliSCAN) in case
    * B: `load_fly_2d_table`, `load_stretch_table`: fix table load on RTC6eth
    * C: `auto_cal`: fix write-back of data to card
    * C: `virtual image field`: set coordinate range to signed 28 bit
    * C: `set_matrix`: value range for coeffs with `HeadNo = 4`: `-2.0..2.0`
    * C: `simulate_ext_start_ctrl`: wait 30 us internally, until list has
         started for sure (if it is allowed)

    NOTE: `import declarations`: some function declarations of the following
          release where included by accident. WorkAround: delete them,
          especially in `RTC6Wrap.cs`, `RTC6expl.{h,c}`

* RTC6RBF.rbf 614:
    * B: poly line: fix possible delayed power changes within a polyline
         that where only applied on the next vector
    * C: `maser/slave`: improve functionality
    * C: `get_sync_status`: add return value for error detection
    * N: `master_slave_config`: configure master/slave connection of a card
    * C: automatic laser control: improve half period regulation (geometrically
         constant spot distance)

# `1.3.3`

* RTC6RBF.rbf 612:
    * B: LaserOff-Timing: fix laser stays on with jump due to ignored
         LaserOff-delay

# `1.3.2`

* RTCBIOSETH.out 22:
    * N: RTC6conf: Can update and flash BIOS in field. (Older BIOS versions
                   cannot be read out and hence must be upgraded by us.)
    * B: Ethernet: Optimize some timings

* RTC6OUT.out 608:
    * C: `ANALOG_IN`: provide AD conversion
    * B: `mark_text`, `mark_text_abs`: make it work
    * B: `list_repeat`, `list_until`: fix wrong repetition if loop was inside
         protected memory area `list 3`

* RTC6DLL.dll 608:
    * N: `eth_get_error`: return accumulated Ethernet error
    * N: `eth_check_connection`: check if ethernet card responds
    * N: `eth_get_ip_search`: retrieve a RTC6eth card's IP by index
    * N: `eth_get_serial_search`: retrieve a RTC6eth card's serial by index
    * B: `table loads, i.e. load_varpoly_delay`: fix DLL exceptions
    * C: `load_program_file`: also check version on RTC6eth cards
    * C: `eth_convert_ip_to_string`, `eth_convert_string_to_ip`: can now be
         used without `init_rtc6_dll`
    * B: `load_sub`, `load_char`: fix rejection (error 64) for finite protected
         list 3 memory area
    * B: `set_verify`: make it work for list commands
    * B: `save_disk`, `load_disk`: fix permanently open file during applicatoin
         runtime
    * B: `eth_get_ip`: make it work for non-default card

# `1.3.1`

* RTCBIOSOUT.out 22:
    * C: Reboot: Reduce reboot duration. PC motherboards with critical timing
                 between PCIe reset and beginning of PCIe link training may
                 now detect the card.

* RTC6OUT.out 607:
    * C: `set_trigger`: add Signal 52, counter for time stamp
    * B: `bounce_supp`: fix bounce filter
    * B: `get_head_status`: fix wrong `PosAck` from head A
    * B: `SCANahead-support`: guarantee `v < v_max`

* RTC6DLL.dll 607:
    * C: `set_trigger`: add Signal 52, counter for time stamp
    * B: `set_scanahead_params`: `Amax` must now be greater than `1/256`
    * B: `load_program_file`: fix memory leak
    * B: `get_z_distance`: fix wrong Z values in RTC4 and RTC5 mode

# `1.3.0`

* RTCBIOSOUT.out 21:
    * N: RTC6conf: Can update and flash BIOS in field. (Older BIOS versions
                   cannot be read out and hence must be upgraded by us.)

* RTC6DAT.dat 601:
    * C: changed data format from the original RTC5DAT.dat format)

* RTC6OUT.out 606:
    * B: improve internal timing
    * B: fix internal commands: i.e. `set_timelag_compensation`
    * B: automatic laser control: make position dependent laser control
         work with `excelliSCAN`

* RTC6DLL.dll 606:
    * B: `auto_cal`: now available for `RTC6eth`
    * C: `master/slave`: now available
    * N: `RTC6eth-Support`: now available for BIOS >= 21
    * N: `get_bios_version`: get BIOS version (available since BIOS 21)

* RTC6RBF.rbf 611:
    * N: `master/slave`: add `master/slave` functionality
